/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.ow2.orchestra.util.Misc;
import org.ow2.util.asm.AnnotationVisitor;
import org.ow2.util.asm.Attribute;
import org.ow2.util.asm.ClassReader;
import org.ow2.util.asm.ClassVisitor;
import org.ow2.util.asm.FieldVisitor;
import org.ow2.util.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassDataTool {
    private ClassDataTool() {
    }

    public static MyVisitor visitClass(byte[] data) {
        MyVisitor mv = new MyVisitor();
        ClassReader cr = new ClassReader(data);
        cr.accept((ClassVisitor)mv, 1);
        return mv;
    }

    public static Set<byte[]> getClasses(Class<?> ... classes) throws IOException {
        HashSet<byte[]> classesSet = new HashSet<byte[]>();
        if (classes != null) {
            for (Class<?> clazz : classes) {
                if (clazz == null) {
                    throw new IOException("Try to add a null class");
                }
                classesSet.add(ClassDataTool.getClassData(clazz));
            }
        }
        return classesSet;
    }

    public static byte[] getClassData(Class<?> clazz) throws IOException {
        if (clazz == null) {
            throw new IOException("Class is null.");
        }
        String className = clazz.getName();
        String newClassName = className.substring(className.lastIndexOf(".") + 1) + ".class";
        InputStream inputStream = clazz.getResourceAsStream(newClassName);
        return Misc.getAllContentFrom(inputStream);
    }

    public static class MyVisitor
    implements ClassVisitor {
        private String className = null;
        private String superClassName = null;
        private String[] interfaces = null;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            this.interfaces = interfaces;
            this.superClassName = superName;
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return null;
        }

        public void visitEnd() {
        }

        public String getClassName() {
            return this.className.replace("/", ".");
        }

        public String getSuperClassName() {
            return this.superClassName;
        }

        public String[] getInterfaces() {
            return this.interfaces;
        }
    }
}

