/**
 * Copyright (C) 2007  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.util;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/**
 * @author Marc Blachon, Guillaume Porcher, Charles Souillard, Miguel Valdes, Pierre Vigneras
 */
public class MBeanInvocationHandler implements InvocationHandler {
  /**
   *
   */
  public static final int CONNECTION_TIMEOUT = 60000;

  private final ObjectName mbeanObjectName;
  private final JMXConnector jmxc;
  private final JMXServiceURL url;

  public MBeanInvocationHandler(final String jmxServiceUrl, final String jmxObjectName)
    throws IOException, MalformedObjectNameException {

    this.url = new JMXServiceURL(jmxServiceUrl);
    this.mbeanObjectName = ObjectName.getInstance(jmxObjectName);

    // Do not keep connection open when idle.
    // JMX server will detect this connection as idle and close the connection
    final Map<String, Object> params = new HashMap<String, Object>();
    params.put("jmx.remote.x.client.connection.check.period" , 0);

    // connect to jmx server
    this.jmxc = JMXConnectorFactory.connect(this.url, params);
  }
  /**
   * @return the jmxc
   */
  public JMXConnector getJmxc() throws IOException {
    return this.jmxc;
  }

  /*
   * (non-Javadoc)
   *
   * @see java.lang.reflect.InvocationHandler#invoke(java.lang.Object,
   *      java.lang.reflect.Method, java.lang.Object[])
   */
  public Object invoke(final Object proxy, final Method method, final Object[] args) throws Throwable {

    final String[] signature = (args == null) ? null : new String[args.length];
    if (args != null) {
      final Class< ? >[] types = method.getParameterTypes();
      for (int i = 0; i < signature.length; i++) {
        signature[i] = types[i].getName();
      }
    }
    try {
      return this.getJmxc().getMBeanServerConnection().invoke(this.mbeanObjectName, method.getName(), args, signature);
    } catch (final RuntimeMBeanException e) {
      throw e.getTargetException();
    }
  }
}
