/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class StandardCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = Logger.getLogger(StandardCallbackHandler.class.getName());

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (LOG.isLoggable(Level.CONFIG)) {
            LOG.config("Using: " + this.getClass().getName() + " to request login informations.");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callback;
                switch (toc.getMessageType()) {
                    case 0: {
                        System.out.println(toc.getMessage());
                        break;
                    }
                    case 2: {
                        System.err.println("ERROR: " + toc.getMessage());
                        break;
                    }
                    case 1: {
                        System.err.println("WARNING: " + toc.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + toc.getMessageType());
                    }
                }
                continue;
            }
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                System.out.println(nc.getPrompt());
                System.out.flush();
                nc.setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                System.out.println(pc.getPrompt());
                System.out.flush();
                pc.setPassword(new BufferedReader(new InputStreamReader(System.in)).readLine().toCharArray());
                continue;
            }
            if (callback instanceof TextInputCallback) {
                TextInputCallback tic = (TextInputCallback)callback;
                System.out.println(tic.getPrompt());
                System.out.flush();
                tic.setText(new BufferedReader(new InputStreamReader(System.in)).readLine());
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }
}

