/**
 * Copyright (C) 2010  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import org.w3c.dom.Document;


public class DocumentProxy implements InvocationHandler {



  private final String documentAsString;
  private Document document;


  /**
   *
   */
  public DocumentProxy(final String documentAsString) {
    this.documentAsString = documentAsString;
  }

  /**
   * @return the documentAsString
   */
  public String getDocumentAsString() {
    return this.documentAsString;
  }

  public boolean isInitialized() {
    return this.document != null;
  }

  /* (non-Javadoc)
   * @see java.lang.reflect.InvocationHandler#invoke(java.lang.Object, java.lang.reflect.Method, java.lang.Object[])
   */
  public Object invoke(final Object proxy, final Method method, final Object[] args) throws Throwable {
    if (this.document == null) {
      this.document = XmlUtil.getDocumentFromString(this.documentAsString, false);
    }
    return method.invoke(this.document, args);
  }
}
