/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakValueMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, WeakValue<K, V>> hash;
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public WeakValueMap(Class<? extends Map> mapType) {
        try {
            this.hash = mapType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public V get(Object key) {
        V result = null;
        WeakReference ref = this.hash.get(key);
        if (ref != null && (result = (V)ref.get()) == null) {
            this.hash.remove(key);
        }
        return result;
    }

    private void processQueue() {
        WeakValue sv;
        while ((sv = (WeakValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakValue<K, V> vw = this.hash.put(key, new WeakValue<K, V>(value, key, this.queue));
        return vw == null ? null : (V)vw.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        WeakValue<K, V> vw = this.hash.remove(key);
        return vw == null ? null : (V)vw.get();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakValue<K, V>
    extends WeakReference<V> {
        private final K key;

        WeakValue(V k, K key, ReferenceQueue<? super V> q) {
            super(k, q);
            this.key = key;
        }
    }
}

