/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util.wsdl;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.xml.WSDLLocator;
import org.ow2.orchestra.util.Misc;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLInMemoryLocator
implements WSDLLocator {
    private static final Logger LOGGER = Logger.getLogger(WSDLInMemoryLocator.class.getName());
    private final Map<String, byte[]> wsdlRepository;
    private String latestImportUri;
    private final String wsdlUrl;
    private String importerPath;

    private String resolveResource(String resource) {
        while (resource.startsWith("./")) {
            resource = resource.substring(2);
        }
        String path = this.importerPath;
        while (resource.startsWith("../")) {
            path = path.substring(path.indexOf("/") + 1);
            resource = resource.substring(3);
        }
        return path + resource;
    }

    public WSDLInMemoryLocator(String wsdlUrl, String importerPath, Map<String, byte[]> wsdlRepository) {
        this.importerPath = importerPath;
        this.wsdlUrl = this.resolveResource(wsdlUrl);
        this.wsdlRepository = wsdlRepository;
    }

    public InputSource getBaseInputSource() {
        Misc.fastDynamicLog(LOGGER, Level.FINE, "getBaseInputSource [wsdlUri=%s]", this.wsdlUrl);
        if (this.wsdlUrl.startsWith("http://") || this.wsdlUrl.startsWith("https://")) {
            return new InputSource(this.wsdlUrl);
        }
        if (!this.wsdlRepository.containsKey(this.wsdlUrl)) {
            return null;
        }
        byte[] content = this.wsdlRepository.get(this.wsdlUrl);
        return new InputSource(new ByteArrayInputStream(content));
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        InputSource inputSource;
        Misc.fastDynamicLog(LOGGER, Level.FINE, "getImportInputSource [parentLocation=%s, importLocation=%s]", parentLocation, importLocation);
        if (importLocation.startsWith("http://") || importLocation.startsWith("https://")) {
            inputSource = new InputSource(importLocation);
        } else {
            byte[] importContent = this.wsdlRepository.get(this.resolveResource(importLocation));
            if (importContent == null) {
                return null;
            }
            inputSource = new InputSource(new ByteArrayInputStream(importContent));
        }
        this.latestImportUri = importLocation;
        return inputSource;
    }

    public String getBaseURI() {
        Misc.fastDynamicLog(LOGGER, Level.FINE, "getBaseURI [wsdlUri=%s]", this.wsdlUrl);
        return this.wsdlUrl;
    }

    public String getLatestImportURI() {
        Misc.fastDynamicLog(LOGGER, Level.FINE, "getLatestImportURI [latestImportUri=%s]", this.latestImportUri);
        return this.latestImportUri;
    }

    public void close() {
    }
}

