/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util.wsdl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaReference;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlInlineUtil {
    private WsdlInlineUtil() {
    }

    private static void inlineImportedXsds(Schema schema, Types types, Set<String> alreadyImportedXsds) {
        NodeList importsNl = schema.getElement().getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (int i = 0; i < importsNl.getLength(); ++i) {
            Element importElt = (Element)importsNl.item(i);
            if (!importElt.hasAttribute("schemaLocation")) continue;
            Map schemaImportsMap = schema.getImports();
            List schemaImports = (List)schemaImportsMap.get(importElt.getAttribute("namespace"));
            for (SchemaReference schemaImport : schemaImports) {
                if (schemaImport.getSchemaLocationURI() == null || !schemaImport.getSchemaLocationURI().equals(importElt.getAttribute("schemaLocation"))) continue;
                if (!alreadyImportedXsds.contains(schemaImport.getSchemaLocationURI())) {
                    alreadyImportedXsds.add(schemaImport.getSchemaLocationURI());
                    WsdlInlineUtil.inlineImportedXsds(schemaImport.getReferencedSchema(), types, alreadyImportedXsds);
                    types.addExtensibilityElement((ExtensibilityElement)schemaImport.getReferencedSchema());
                }
                schemaImport.setSchemaLocationURI(null);
                importElt.removeAttribute("schemaLocation");
            }
        }
        NodeList includeNl = schema.getElement().getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        for (int i = 0; i < includeNl.getLength(); ++i) {
            Element includeElt = (Element)includeNl.item(i);
            if (!includeElt.hasAttribute("schemaLocation")) continue;
            for (SchemaReference schemaReference : schema.getIncludes()) {
                if (schemaReference.getSchemaLocationURI() == null || !schemaReference.getSchemaLocationURI().equals(includeElt.getAttribute("schemaLocation"))) continue;
                if (!alreadyImportedXsds.contains(schemaReference.getSchemaLocationURI())) {
                    alreadyImportedXsds.add(schemaReference.getSchemaLocationURI());
                    WsdlInlineUtil.inlineImportedXsds(schemaReference.getReferencedSchema(), types, alreadyImportedXsds);
                    types.addExtensibilityElement((ExtensibilityElement)schemaReference.getReferencedSchema());
                }
                schemaReference.setSchemaLocationURI(null);
                includeElt.removeAttribute("schemaLocation");
            }
        }
        NodeList redefinesNl = schema.getElement().getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "redefine");
        for (int i = 0; i < redefinesNl.getLength(); ++i) {
            Element redefineElt = (Element)redefinesNl.item(i);
            if (!redefineElt.hasAttribute("schemaLocation")) continue;
            for (SchemaReference schemaReference : schema.getRedefines()) {
                if (schemaReference.getSchemaLocationURI() == null || !schemaReference.getSchemaLocationURI().equals(redefineElt.getAttribute("schemaLocation"))) continue;
                if (!alreadyImportedXsds.contains(schemaReference.getSchemaLocationURI())) {
                    alreadyImportedXsds.add(schemaReference.getSchemaLocationURI());
                    WsdlInlineUtil.inlineImportedXsds(schemaReference.getReferencedSchema(), types, alreadyImportedXsds);
                    types.addExtensibilityElement((ExtensibilityElement)schemaReference.getReferencedSchema());
                }
                schemaReference.setSchemaLocationURI(null);
                redefineElt.removeAttribute("schemaLocation");
            }
        }
    }

    public static void inlineWsdlFile(Definition wsdlDefinition) {
        Types types;
        Map imports = wsdlDefinition.getImports();
        if (!imports.isEmpty()) {
            for (List l : imports.values()) {
                for (Import impor : l) {
                    Definition importedDefinition = impor.getDefinition();
                    WsdlInlineUtil.inlineWsdlFile(importedDefinition);
                }
            }
        }
        if ((types = wsdlDefinition.getTypes()) != null) {
            for (ExtensibilityElement elt : new ArrayList(types.getExtensibilityElements())) {
                if (!(elt instanceof Schema)) continue;
                Schema schema = (Schema)elt;
                WsdlInlineUtil.inlineImportedXsds(schema, types, new HashSet<String>());
            }
        }
    }
}

