/*
 * Decompiled with CFR 0.152.
 */
package eu.play_project.play_commons.constants;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Constants {
    private static Properties properties;
    private static final String PROPERTIES = "play-commons-constants.properties";
    private static final String PROPERTIES_DEFAULTS = "play-commons-constants-defaults.properties";

    public static Properties getProperties() {
        if (properties == null) {
            properties = Constants.getProperties(PROPERTIES, Constants.getProperties(PROPERTIES_DEFAULTS));
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String fileName) {
        Properties result = new Properties();
        InputStream stream = Constants.class.getClassLoader().getResourceAsStream(fileName);
        if (stream != null) {
            try {
                result.load(stream);
            }
            catch (IOException e) {
                result = new Properties();
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String fileName, Properties defaultProperties) {
        Properties result = new Properties(defaultProperties);
        InputStream stream = Constants.class.getClassLoader().getResourceAsStream(fileName);
        if (stream != null) {
            try {
                result.load(stream);
            }
            catch (IOException e) {
                result = new Properties(defaultProperties);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
        return result;
    }
}

