/*
 * Decompiled with CFR 0.152.
 */
package eu.play_project.play_commons.constants;

import eu.play_project.play_commons.constants.Namespace;
import javax.xml.namespace.QName;

public enum Stream {
    FacebookStatusFeed(Namespace.STREAMS, "FacebookStatusFeed#stream"),
    FacebookCepResults(Namespace.STREAMS, "FacebookCepResults#stream"),
    PachubeFeed(Namespace.STREAMS, "PachubeFeed#stream"),
    TwitterFeed(Namespace.STREAMS, "TwitterFeed#stream"),
    PersonalMonitoring(Namespace.STREAMS, "PersonalMonitoring#stream"),
    SituationalEventStream(Namespace.STREAMS, "situationalEvent#stream"),
    SituationalAlertEventStream(Namespace.STREAMS, "situationalAlertEvent#stream"),
    ActivityEventStream(Namespace.STREAMS, "activityEvent#stream"),
    ResourcesEventStream(Namespace.STREAMS, "resourcesEvent#stream"),
    ConsequenceEventStream(Namespace.STREAMS, "consequenceEvent#stream"),
    VisualizationEventStream(Namespace.STREAMS, "visualizationEvent#stream"),
    ESRRecom(Namespace.STREAMS, "ESRRecom#stream"),
    SARRecom(Namespace.STREAMS, "SARRecom#stream"),
    VesselStream(Namespace.STREAMS, "VesselStream#stream"),
    ProximityInfoStream(Namespace.STREAMS, "ProximityInfoStream#stream"),
    TaxiUCCall(Namespace.STREAMS, "TaxiUCCall#stream"),
    TaxiUCClic2Call(Namespace.STREAMS, "TaxiUCClic2Call#stream"),
    TaxiUCFaceBook(Namespace.STREAMS, "TaxiUCFaceBook#stream"),
    TaxiUCGeoLocation(Namespace.STREAMS, "TaxiUCGeoLocation#stream"),
    TaxiUCTwitter(Namespace.STREAMS, "TaxiUCTwitter#stream"),
    ContextualizedLatitudeFeed(Namespace.STREAMS, "ContextualizedLatitudeFeed#stream"),
    TaxiUCESRRecom(Namespace.STREAMS, "TaxiUCESRRecom#stream"),
    TaxiUCESRRecomDcep(Namespace.STREAMS, "TaxiUCESRRecomDcep#stream"),
    Friend_Geo_Event(Namespace.STREAMS, "Friend_Geo_Event#stream"),
    TaxiUCAnswer(Namespace.STREAMS, "TaxiUCAnswer#stream");

    private final QName qname;
    public static final String STREAM_ID_SUFFIX = "#stream";
    public static final String STREAM_TITLE = "http://purl.org/dc/elements/1.1/title";
    public static final String STREAM_DESCRIPTION = "http://purl.org/dc/elements/1.1/description";
    public static final String STREAM_ICON = "http://www.w3.org/2002/06/xhtml2/icon";
    public static final String STREAM_TOPIC = "http://www.play-project.eu/xml/ns/topic";
    public static final String STREAM_COMPLEXEVENTS = "http://www.play-project.eu/xml/ns/complexEvents";
    public static final String STREAM_DSBNEEDSTOSUBSCRIBE = "http://www.play-project.eu/xml/ns/dsbneedstosubscribe";

    private Stream(String namespaceUri, String localpart, String prefix) {
        this.qname = new QName(namespaceUri, localpart, prefix);
    }

    private Stream(Namespace namespace, String localpart) {
        this.qname = new QName(namespace.getUri(), localpart, namespace.getPrefix());
    }

    private Stream(QName qname) {
        this.qname = qname;
    }

    public QName getQName() {
        return this.qname;
    }

    public String getUri() {
        return this.qname.getNamespaceURI() + this.qname.getLocalPart();
    }

    public String getTopicUri() {
        return Stream.toTopicUri(this.getUri());
    }

    public static String toTopicUri(String streamId) {
        return streamId.substring(0, streamId.lastIndexOf("#"));
    }

    public QName getTopicQName() {
        return Stream.toTopicQName(this.getQName());
    }

    public static QName toTopicQName(QName streamId) {
        return new QName(streamId.getNamespaceURI(), streamId.getLocalPart().substring(0, streamId.getLocalPart().lastIndexOf("#")), streamId.getPrefix());
    }

    public String toString() {
        return this.getUri();
    }
}

