/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.scarbo.sca.generators;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SCAProxyImplGenerator {
    public static final String PROXY_SUFFIX = "SCAProxy";
    private String _package;
    private String destinationFolder;
    private Class<?> serviceType;

    public SCAProxyImplGenerator(Class<?> serviceType, String _package, String destinationFolder) {
        PrintStream output;
        this._package = _package;
        this.destinationFolder = destinationFolder;
        this.serviceType = serviceType;
        this.createFolder(destinationFolder, _package);
        try {
            output = new PrintStream(this.getFileName());
        }
        catch (Exception ex) {
            System.err.println("Could not create File " + this.getFileName());
            System.err.println("Output set to stderr");
            output = System.err;
        }
        if (!serviceType.isInterface()) {
            output.close();
            throw new IllegalArgumentException("The class " + serviceType.getName() + " is not an interface, so that it is not a service...");
        }
        for (int i = 0; i < serviceType.getDeclaredClasses().length; ++i) {
            output.println("import " + serviceType.getDeclaredClasses()[i]);
        }
        this.printPackage(_package, output);
        this.printClass(serviceType, output);
        output.print(" {");
        output.println();
        this.printDelegate(serviceType, output);
        output.println();
        this.printMethods(serviceType, output);
        output.print("}");
        output.close();
    }

    private String getFileName() {
        return this.destinationFolder + File.separator + this._package.replace(".", File.separator) + File.separator + this.serviceType.getSimpleName() + "SCAProxy.java";
    }

    public String getGeneratedImplementationName() {
        return this._package + '.' + this.serviceType.getSimpleName() + PROXY_SUFFIX;
    }

    public File getServiceImplementation() {
        return new File(this.getFileName());
    }

    private void createFolder(String destinationFolder, String _package) {
        new File(destinationFolder + File.separator + _package.replace('.', File.separatorChar)).mkdirs();
    }

    private void printPackage(String _package, PrintStream output) {
        output.println("package " + _package + ";");
        output.println();
    }

    private void printDelegate(Class<?> serviceType, PrintStream output) {
        output.println("@org.osoa.sca.annotations.Reference");
        output.println("public " + serviceType.getName() + " delegate;");
    }

    private void printClass(Class<?> serviceType, PrintStream output) {
        output.println("public class " + serviceType.getSimpleName() + PROXY_SUFFIX + " implements " + serviceType.getName());
    }

    private void printMethods(Class<?> serviceType, PrintStream output) {
        for (Method method : serviceType.getDeclaredMethods()) {
            this.printSignature(output, method);
            this.printBody(output, method);
            output.println();
        }
    }

    private void printBody(PrintStream output, Method method) {
        output.print("{\n");
        if (!method.getReturnType().toString().equals("void")) {
            output.print("return ");
        }
        output.print("delegate." + method.getName() + "(");
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            output.print("arg" + i);
            if (i == method.getParameterTypes().length - 1) continue;
            output.print(", ");
        }
        output.print(");\n");
        output.print("}\n");
    }

    private void printSignature(PrintStream output, Method method) {
        int i;
        output.print("public " + this.getJavaTypeString(method.getReturnType()) + " " + method.getName() + "(");
        for (i = 0; i < method.getParameterTypes().length; ++i) {
            output.print(this.getJavaTypeString(method.getParameterTypes()[i]) + " arg" + i);
            if (i == method.getParameterTypes().length - 1) continue;
            output.print(", ");
        }
        output.print(") ");
        if (method.getExceptionTypes().length == 0) {
            return;
        }
        output.print("throws ");
        for (i = 0; i < method.getExceptionTypes().length; ++i) {
            output.print(method.getExceptionTypes()[i].getName());
            if (i == method.getExceptionTypes().length - 1) continue;
            output.print(",");
        }
        output.print(" ");
    }

    private String getJavaTypeString(Class<?> returnType) {
        if (returnType.isArray()) {
            return returnType.getComponentType().getName() + "[]";
        }
        return returnType.getName();
    }
}

