/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.scarbo.sca.generators;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SCAProxyCompositeGenerator {
    private Namespace ns;
    private Class<?> service;

    public SCAProxyCompositeGenerator(Class<?> service, Class<?> impl, String targetNamespace, String compositeName, String outputFile) throws IOException {
        this.service = service;
        if (!service.isInterface()) {
            System.err.println("The service is not an interface, thus, it is not really a service");
            return;
        }
        if (!service.isAssignableFrom(impl)) {
            System.err.println("The implementation is not an implementation of the service");
            return;
        }
        new File(outputFile).getParentFile().mkdirs();
        DocumentFactory documentFactory = new DocumentFactory();
        this.ns = documentFactory.createNamespace("", "http://www.osoa.org/xmlns/sca/1.0");
        Document composite = documentFactory.createDocument();
        Element compositeElement = documentFactory.createElement(new QName("composite", this.ns));
        compositeElement.addAttribute("targetNamespace", targetNamespace);
        compositeElement.addAttribute("name", compositeName);
        composite.setRootElement(compositeElement);
        Element componentElement = compositeElement.addElement(new QName("component", this.ns));
        componentElement.addAttribute("name", this.getComponentName(service));
        this.addService(service, impl, componentElement);
        this.addReferences(service, impl, componentElement);
        this.addCompositeService(service, compositeElement);
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(outputFile), format);
        writer.write(composite);
        writer.flush();
        writer.close();
    }

    private String getComponentName(Class<?> service) {
        return service.getSimpleName() + "Component";
    }

    private void addCompositeService(Class<?> service, Element compositeElement) {
        Element serviceElement = compositeElement.addElement(new QName("service", this.ns));
        serviceElement.addAttribute("name", service.getSimpleName() + "Service");
        serviceElement.addAttribute("promote", this.getComponentName(service) + "/" + this.getComponentServiceName(service));
        serviceElement.addElement(new QName("interface.java", this.ns)).addAttribute("interface", service.getName());
        serviceElement.addElement(new QName("binding.sca", this.ns));
    }

    private void addReferences(Class<?> service, Class<?> impl, Element componentElement) {
        for (int i = 0; i < impl.getFields().length; ++i) {
            if (impl.getFields()[i].getAnnotation(Reference.class) == null) continue;
            this.addReference(impl.getFields()[i], componentElement);
        }
    }

    private void addReference(Field field, Element componentElement) {
        Element referenceElement = componentElement.addElement(new QName("reference", this.ns));
        referenceElement.addAttribute("name", field.getName());
        referenceElement.addElement(new QName("interface.java", this.ns)).addAttribute("interface", field.getType().getName());
        referenceElement.addElement(new QName("binding.sca", this.ns));
    }

    private void addService(Class<?> service, Class<?> impl, Element componentElement) {
        componentElement.addElement(new QName("implementation.java", this.ns)).addAttribute("class", impl.getName());
        Element componentServiceElement = componentElement.addElement("service");
        componentServiceElement.addAttribute("name", this.getComponentServiceName(service));
        componentServiceElement.addElement(new QName("interface.java", this.ns)).addAttribute("interface", service.getName());
        componentServiceElement.addElement(new QName("binding.sca", this.ns));
    }

    private String getComponentServiceName(Class<?> service) {
        return service.getSimpleName() + "ComponentService";
    }

    public String getCompositeServiceName() {
        return this.service.getSimpleName() + "Service";
    }
}

