/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.scarbo.sca.generators;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.osoa.sca.annotations.Reference;
import org.ow2.scarbo.sca.generators.SCAProxyCompositeGenerator;
import org.ow2.scarbo.sca.generators.SCAProxyImplGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCAProxyGenerator {
    private static final String TUSCANY_RMI_NAMESPACE = "http://tuscany.apache.org/xmlns/sca/1.0";
    private String classFolder;
    private Class<?> serviceType;
    private Class<?> impl;
    private String sourceFolder;
    private Object resourceFolder;
    private String uri;
    private SCAProxyCompositeGenerator proxyCompositeGenerator = null;
    private SCAProxyImplGenerator proxyImplGenerator = null;
    private Class<?>[] additionalClasses;
    private RMIDetails rmiDetails;

    public SCAProxyGenerator(String sourceFolder, String resourceFolder, String destinationFolder, Class<?> serviceType, String uri, Class<?> ... additionalBuildClasses) throws Exception {
        this.classFolder = destinationFolder;
        this.serviceType = serviceType;
        this.sourceFolder = sourceFolder;
        this.resourceFolder = resourceFolder;
        this.uri = uri;
        this.additionalClasses = additionalBuildClasses;
        this.generate();
    }

    public SCAProxyGenerator(String sourceFolder, String resourceFolder, String destinationFolder, Class<?> serviceType, RMIDetails rmiDetails, Class<?> ... additionalBuildClasses) throws Exception {
        this.classFolder = destinationFolder;
        this.serviceType = serviceType;
        this.sourceFolder = sourceFolder;
        this.resourceFolder = resourceFolder;
        this.rmiDetails = rmiDetails;
        this.additionalClasses = additionalBuildClasses;
        this.generate();
    }

    public Class<?> getServiceType() {
        return this.serviceType;
    }

    public File getComposite() {
        return new File(this.resourceFolder + File.separator + this.impl.getName() + ".composite").getAbsoluteFile();
    }

    private void generate() throws Exception {
        this.generateServiceImpl();
        this.proxyCompositeGenerator = new SCAProxyCompositeGenerator(this.serviceType, this.impl, this.getTargetNamespace(), this.impl.getSimpleName() + "Composite", this.getComposite().getPath());
        this.setReferenceBinding();
    }

    private void setReferenceBinding() throws DocumentException, JaxenException, IOException {
        SAXReader reader = new SAXReader();
        File input = this.getComposite();
        Document document = reader.read(input);
        HashMap<String, String> xpathContext = new HashMap<String, String>();
        xpathContext.put("sca", document.getRootElement().getNamespace().getStringValue());
        Dom4jXPath xpath = new Dom4jXPath("//sca:reference[@name='delegate']/sca:binding.sca");
        xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(xpathContext));
        List result = xpath.selectNodes((Object)document);
        if (result.size() != 0) {
            Element bindingNode = (Element)result.get(0);
            if (this.uri != null) {
                bindingNode.setQName(new QName("binding.ws", document.getRootElement().getNamespace()));
                bindingNode.addAttribute("uri", this.uri);
            } else if (this.rmiDetails != null) {
                bindingNode.setQName(new QName("binding.rmi", new Namespace("rmi", TUSCANY_RMI_NAMESPACE)));
                bindingNode.addAttribute("host", this.rmiDetails.host);
                bindingNode.addAttribute("port", Integer.toString(this.rmiDetails.port));
                bindingNode.addAttribute("serviceName", this.rmiDetails.serviceName);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(input), format);
            writer.write(document);
            writer.flush();
        }
    }

    public File getGeneratedJavaFile() throws IOException {
        return this.proxyImplGenerator.getServiceImplementation();
    }

    public String getGeneratedImplementationName() {
        return this.proxyImplGenerator.getGeneratedImplementationName();
    }

    public Class<?> getGeneratedImplementationClass() {
        return this.impl;
    }

    private String getTargetNamespace() {
        return "http://hw.example";
    }

    public String getImplementationPackage() {
        return this.serviceType.getPackage().getName() + ".generatedSCAProxy";
    }

    private void generateServiceImpl() throws ClassNotFoundException, IOException, InterruptedException {
        this.proxyImplGenerator = new SCAProxyImplGenerator(this.serviceType, this.getImplementationPackage(), this.sourceFolder);
        new File(this.classFolder).mkdirs();
        ArrayList<String> args = this.createCompilationArguments(this.proxyImplGenerator.getServiceImplementation());
        ProcessBuilder compilerProcess = new ProcessBuilder(args.toArray(new String[0]));
        Process proc = compilerProcess.start();
        int res = proc.waitFor();
        if (res != 0) {
            String line;
            BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            while ((line = out.readLine()) != null) {
                System.err.println(line);
            }
            while ((line = err.readLine()) != null) {
                System.err.println(line);
            }
            throw new ClassNotFoundException("Build failed: Error " + res);
        }
        URLClassLoader cl = new URLClassLoader(new URL[]{new File(this.classFolder).toURI().toURL()}, this.serviceType.getClassLoader());
        String implementationClassName = this.getImplementationPackage() + "." + this.serviceType.getSimpleName() + "SCAProxy";
        this.setImpl(cl.loadClass(implementationClassName));
    }

    private ArrayList<String> createCompilationArguments(File generatedJavaFile) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("javac");
        args.add(generatedJavaFile.getPath());
        args.add("-d");
        args.add(this.classFolder);
        ClassPath classpath = new ClassPath(this.serviceType);
        classpath.add(Reference.class);
        classpath.add(this.serviceType);
        for (Class<?> clazz : this.additionalClasses) {
            classpath.add(clazz);
        }
        args.add("-cp");
        args.add(classpath.toString());
        return args;
    }

    private void setImpl(Class<?> klass) {
        this.impl = klass;
    }

    private void addURLtoClasspath(URL url) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, url);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public String getCompositeServiceName() {
        return this.proxyCompositeGenerator.getCompositeServiceName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassPath {
        private Set<Class<?>> dependencies = new HashSet();

        public ClassPath(Class<?> type) {
            this.evaluateDependencies(type);
        }

        private String getResourceForClass(Class<?> clazz) {
            URL resource;
            if (clazz.getClassLoader() == null) {
                return null;
            }
            String classRelativePath = clazz.getName().replace(".", "/") + ".class";
            if (classRelativePath == null) {
                classRelativePath = clazz.getName().replace(".", "/") + ".java";
            }
            if ((resource = clazz.getClassLoader().getResource(classRelativePath)) == null) {
                resource = this.getClass().getClassLoader().getResource(classRelativePath);
            }
            if (resource == null) {
                return null;
            }
            String resoutceAbsolutePath = resource.toString();
            try {
                if (resoutceAbsolutePath.startsWith("jar:file:")) {
                    return resoutceAbsolutePath.substring(0, resoutceAbsolutePath.lastIndexOf(33)).substring(9);
                }
                if (resoutceAbsolutePath.startsWith("file:")) {
                    String filePath = new File(resource.toURI()).getAbsolutePath();
                    return filePath.substring(0, filePath.length() - classRelativePath.length());
                }
                return new File(resource.toURI()).getAbsolutePath();
            }
            catch (Exception ex) {
                return null;
            }
        }

        private void evaluateDependencies(Class<?> type) {
            if (this.dependencies.contains(type)) {
                return;
            }
            if (type.isPrimitive()) {
                return;
            }
            if (type.getPackage() == null || type.getPackage().getName().equals("java.lang")) {
                return;
            }
            this.addDependency(type);
            for (Annotation annot : type.getAnnotations()) {
                this.evaluateDependencies(annot.annotationType());
            }
            Method[] methods = type.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                int j;
                for (Annotation annot : methods[i].getAnnotations()) {
                    this.evaluateDependencies(annot.annotationType());
                }
                this.evaluateDependencies(methods[i].getReturnType());
                for (j = 0; j < methods[i].getParameterTypes().length; ++j) {
                    this.evaluateDependencies(methods[i].getParameterTypes()[j]);
                }
                for (j = 0; j < methods[i].getExceptionTypes().length; ++j) {
                    this.evaluateDependencies(methods[i].getExceptionTypes()[j]);
                }
            }
            for (Class<?> clazz : type.getInterfaces()) {
                this.evaluateDependencies(clazz);
            }
            if (type.getSuperclass() != null) {
                this.evaluateDependencies(type.getSuperclass());
            }
        }

        private void addDependency(Class<?> returnType) {
            if (returnType.isPrimitive()) {
                return;
            }
            if (returnType.isArray()) {
                this.evaluateDependencies(returnType.getComponentType());
            }
            this.dependencies.add(returnType);
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            for (Class<?> klass : this.dependencies) {
                String resource = this.getResourceForClass(klass);
                if (resource == null) continue;
                res.append(resource + System.getProperty("path.separator"));
            }
            if (res.length() != 0) {
                return res.substring(0, res.length() - 1);
            }
            return res.toString();
        }

        public void add(Class<?> klass) {
            this.dependencies.add(klass);
        }
    }

    public static class RMIDetails {
        public String host;
        public int port;
        public String serviceName;

        public RMIDetails() {
        }

        public RMIDetails(String host, int port, String serviceName) {
            this.host = host;
            this.port = port;
            this.serviceName = serviceName;
        }
    }
}

