/**
 * Copyright 2010 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.commands.config.internal.completer;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

/**
 * Created by IntelliJ IDEA.
 * User: Guillaume
 * Date: 28 janv. 2010
 * Time: 21:05:49
 * To change this template use File | Settings | File Templates.
 */
@Component(propagation = true)
@Provides(specifications = {Completer.class, ConfigurationListener.class})
public class ConfigurationCompleter extends StringsCompleter implements ConfigurationListener {

    private SortedSet<String> configurations;

    /**
     * Create a new StringsCompleter with a single possible completion
     * values.
     */
    public ConfigurationCompleter() {
        super("");
        configurations = new TreeSet<String>();
    }

    @Override
    public int complete(String buffer, int cursor, List<CharSequence> clist) {
        // Update candidates list
        getStrings().clear();
        getStrings().addAll(configurations);
        return super.complete(buffer, cursor, clist);
    }

    /**
     * Receives notification of a Configuration that has changed.
     *
     * @param event The <code>ConfigurationEvent</code>.
     */
    public void configurationEvent(ConfigurationEvent event) {
        switch (event.getType()) {
            case ConfigurationEvent.CM_UPDATED:
                configurations.add(event.getPid());
                break;
            case ConfigurationEvent.CM_DELETED:
                configurations.remove(event.getPid());
                break;
        }
    }
}
