/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.config.internal;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(name="details", scope="config", description="Print the content of a Configurations")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class DetailsConfigurationAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Fverbose;
    @Option(name="-v", aliases={"--verbose"}, description="Verbose mode: prints extra information.")
    private boolean verbose;
    private boolean __Fpid;
    @Argument(name="pid", required=true, description="Service (or factory) PID of the Configuration to show.")
    private String pid;
    private boolean __Fca;
    private final ConfigurationAdmin ca;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;
    private boolean __MprintType$java_lang_Class;
    private boolean __MprintArray$java_lang_Object;

    boolean __getverbose() {
        if (!this.__Fverbose) {
            return this.verbose;
        }
        Object object = this.__IM.onGet((Object)this, "verbose");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setverbose(boolean bl) {
        if (!this.__Fverbose) {
            this.verbose = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "verbose", (Object)bl2);
    }

    String __getpid() {
        if (!this.__Fpid) {
            return this.pid;
        }
        return (String)this.__IM.onGet((Object)this, "pid");
    }

    void __setpid(String string) {
        if (!this.__Fpid) {
            this.pid = string;
            return;
        }
        this.__IM.onSet((Object)this, "pid", (Object)string);
    }

    ConfigurationAdmin __getca() {
        if (!this.__Fca) {
            return this.ca;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "ca");
    }

    void __setca(ConfigurationAdmin configurationAdmin) {
        if (!this.__Fca) {
            this.ca = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "ca", (Object)configurationAdmin);
    }

    public DetailsConfigurationAction(ConfigurationAdmin configurationAdmin) {
        this(null, configurationAdmin);
    }

    private DetailsConfigurationAction(@Requires InstanceManager _manager, ConfigurationAdmin ca) {
        this._setInstanceManager(_manager);
        this.__setca(ca);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        Configuration config = this.__getca().getConfiguration(this.__getpid(), null);
        if (config != null) {
            Dictionary dict;
            boolean bound;
            Ansi buffer = Ansi.ansi();
            buffer.a(Ansi.Attribute.INTENSITY_BOLD);
            buffer.a(config.getPid());
            buffer.a(Ansi.Attribute.INTENSITY_BOLD_OFF);
            String location = config.getBundleLocation();
            boolean bl = bound = location != null;
            if (config.getFactoryPid() != null) {
                buffer.a(" [factory]");
            }
            if (this.__getverbose() && !bound) {
                buffer.render(" (unbound)");
            }
            buffer.newline();
            if (this.__getverbose() && bound) {
                buffer.render("  bound to %s", new Object[]{location});
                buffer.newline();
            }
            if ((dict = config.getProperties()) != null) {
                Enumeration e = dict.keys();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Object value = dict.get(name);
                    String printable = value.toString();
                    if (value.getClass().isArray()) {
                        printable = this.printArray(value);
                    }
                    buffer.render("  * %s=%s", new Object[]{name, printable});
                    if (this.__getverbose()) {
                        buffer.render(" (@|italic %s|@)", new Object[]{this.printType(value.getClass())});
                    }
                    buffer.newline();
                }
            }
            System.out.print(buffer.toString());
        }
        return null;
    }

    private String printType(Class<?> clazz) {
        String string;
        if (!this.__MprintType$java_lang_Class) {
            return this.__M_printType(clazz);
        }
        try {
            this.__IM.onEntry((Object)this, "printType$java_lang_Class", new Object[]{clazz});
            string = this.__M_printType(clazz);
            this.__IM.onExit((Object)this, "printType$java_lang_Class", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printType$java_lang_Class", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_printType(Class<?> type) {
        if (type.isArray()) {
            return this.printType(type.getComponentType()) + "[]";
        }
        if (Long.TYPE.equals(type)) {
            return "long";
        }
        if (Byte.TYPE.equals(type)) {
            return "byte";
        }
        if (Integer.TYPE.equals(type)) {
            return "int";
        }
        if (Float.TYPE.equals(type)) {
            return "float";
        }
        if (Character.TYPE.equals(type)) {
            return "char";
        }
        if (Double.TYPE.equals(type)) {
            return "double";
        }
        if (Short.TYPE.equals(type)) {
            return "short";
        }
        if (Boolean.TYPE.equals(type)) {
            return "boolean";
        }
        return type.getName();
    }

    private String printArray(Object object) {
        String string;
        if (!this.__MprintArray$java_lang_Object) {
            return this.__M_printArray(object);
        }
        try {
            this.__IM.onEntry((Object)this, "printArray$java_lang_Object", new Object[]{object});
            string = this.__M_printArray(object);
            this.__IM.onExit((Object)this, "printArray$java_lang_Object", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printArray$java_lang_Object", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_printArray(Object o) {
        if (o instanceof long[]) {
            return Arrays.toString((long[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.toString((byte[])o);
        }
        if (o instanceof int[]) {
            return Arrays.toString((int[])o);
        }
        if (o instanceof float[]) {
            return Arrays.toString((float[])o);
        }
        if (o instanceof char[]) {
            return Arrays.toString((char[])o);
        }
        if (o instanceof double[]) {
            return Arrays.toString((double[])o);
        }
        if (o instanceof short[]) {
            return Arrays.toString((short[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.toString((boolean[])o);
        }
        if (o instanceof String[]) {
            return Arrays.toString((String[])o);
        }
        return o.toString();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("ca")) {
                this.__Fca = true;
            }
            if (set.contains("pid")) {
                this.__Fpid = true;
            }
            if (set.contains("verbose")) {
                this.__Fverbose = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("execute$org_apache_felix_service_command_CommandSession")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("printType$java_lang_Class")) {
                this.__MprintType$java_lang_Class = true;
            }
            if (set.contains("printArray$java_lang_Object")) {
                this.__MprintArray$java_lang_Object = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    public DetailsConfigurationAction(InstanceManager instanceManager) {
        this._setInstanceManager(instanceManager);
    }
}

