/**
 * Copyright 2012 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.shelbie.commands.felix.internal;

import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.shell.Command;
import org.ow2.shelbie.core.IConverterManager;

import java.util.List;

/**
 * @author Loris Bouzonnet
 */
public class FelixCommandWrapper implements Function {

    private final Command command;

    private final IConverterManager converterManager;

    public FelixCommandWrapper(Command command, IConverterManager converterManager) {
        this.command = command;
        this.converterManager = converterManager;
    }

    public Object execute(CommandSession commandSession, List<Object> objects) throws Exception {

        StringBuilder arguments = new StringBuilder(command.getName());
        for (Object arg : objects) {
            arguments.append(" ");
            String convertedArg = (String) converterManager.convert(String.class, arg);
            if (convertedArg == null) {
                convertedArg = arg.toString();
            }
            arguments.append(convertedArg);
        }

        command.execute(arguments.toString(), commandSession.getConsole(), commandSession.getConsole());
        return null;
    }
}
