/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ipojo.internal;

import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;

@Command(name="instances", scope="arch", description="List the component instances")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class InstancesAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Farchitectures;
    @Requires(optional=true)
    private Architecture[] architectures;
    private boolean __Fverbose;
    @Option(name="-v", aliases={"--verbose"}, description="When activated, display DISPOSED instances as well.", required=false)
    private boolean verbose;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;
    private boolean __MgetStateName$int;
    private boolean __MgetStateColor$int;
    private boolean __MprintInstanceInfos$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_architecture_InstanceDescription;

    Architecture[] __getarchitectures() {
        if (!this.__Farchitectures) {
            return this.architectures;
        }
        return (Architecture[])this.__IM.onGet((Object)this, "architectures");
    }

    void __setarchitectures(Architecture[] architectureArray) {
        if (!this.__Farchitectures) {
            this.architectures = architectureArray;
            return;
        }
        this.__IM.onSet((Object)this, "architectures", (Object)architectureArray);
    }

    boolean __getverbose() {
        if (!this.__Fverbose) {
            return this.verbose;
        }
        Object object = this.__IM.onGet((Object)this, "verbose");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setverbose(boolean bl) {
        if (!this.__Fverbose) {
            this.verbose = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "verbose", (Object)bl2);
    }

    public InstancesAction() {
        this(null);
    }

    private InstancesAction(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setverbose(false);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        Ansi buffer = Ansi.ansi();
        if (this.__getarchitectures().length != 0) {
            buffer.a(Ansi.Attribute.INTENSITY_BOLD);
            buffer.a("[ Status ] Instance name\n");
            buffer.a(Ansi.Attribute.INTENSITY_BOLD_OFF);
        }
        for (Architecture arch : this.__getarchitectures()) {
            InstanceDescription instance = arch.getInstanceDescription();
            if (instance.getState() != -1) {
                this.printInstanceInfos(buffer, instance);
                continue;
            }
            if (!this.__getverbose()) continue;
            this.printInstanceInfos(buffer, instance);
        }
        System.out.println(buffer.toString());
        return null;
    }

    private String getStateName(int n) {
        String string;
        if (!this.__MgetStateName$int) {
            return this.__M_getStateName(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getStateName$int", new Object[]{new Integer(n)});
            string = this.__M_getStateName(n);
            this.__IM.onExit((Object)this, "getStateName$int", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getStateName$int", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getStateName(int state) {
        switch (state) {
            case 2: {
                return "   VALID";
            }
            case 1: {
                return " INVALID";
            }
            case 0: {
                return " STOPPED";
            }
            case -1: {
                return "DISPOSED";
            }
        }
        return "";
    }

    private Ansi.Color getStateColor(int n) {
        Ansi.Color color;
        if (!this.__MgetStateColor$int) {
            return this.__M_getStateColor(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getStateColor$int", new Object[]{new Integer(n)});
            color = this.__M_getStateColor(n);
            this.__IM.onExit((Object)this, "getStateColor$int", (Object)color);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getStateColor$int", throwable);
            throw throwable;
        }
        return color;
    }

    private Ansi.Color __M_getStateColor(int state) {
        switch (state) {
            case 2: {
                return Ansi.Color.GREEN;
            }
            case 1: {
                return Ansi.Color.RED;
            }
            case 0: {
                return Ansi.Color.YELLOW;
            }
            case -1: {
                return Ansi.Color.BLUE;
            }
        }
        return Ansi.Color.DEFAULT;
    }

    private void printInstanceInfos(Ansi ansi, InstanceDescription instanceDescription) {
        if (!this.__MprintInstanceInfos$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_architecture_InstanceDescription) {
            this.__M_printInstanceInfos(ansi, instanceDescription);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printInstanceInfos$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_architecture_InstanceDescription", new Object[]{ansi, instanceDescription});
            this.__M_printInstanceInfos(ansi, instanceDescription);
            this.__IM.onExit((Object)this, "printInstanceInfos$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_architecture_InstanceDescription", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printInstanceInfos$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_architecture_InstanceDescription", throwable);
            throw throwable;
        }
    }

    private void __M_printInstanceInfos(Ansi buffer, InstanceDescription instance) {
        int state = instance.getState();
        buffer.a("[");
        buffer.fg(this.getStateColor(state));
        buffer.a(this.getStateName(state));
        buffer.fg(Ansi.Color.DEFAULT);
        buffer.a("] ");
        buffer.a(instance.getName());
        buffer.a('\n');
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("architectures")) {
                this.__Farchitectures = true;
            }
            if (set.contains("verbose")) {
                this.__Fverbose = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("execute$org_apache_felix_service_command_CommandSession")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("getStateName$int")) {
                this.__MgetStateName$int = true;
            }
            if (set.contains("getStateColor$int")) {
                this.__MgetStateColor$int = true;
            }
            if (set.contains("printInstanceInfos$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_architecture_InstanceDescription")) {
                this.__MprintInstanceInfos$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_architecture_InstanceDescription = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

