/**
 * Copyright 2013 Peergreen S.A.S.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ow2.shelbie.testing.internal;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Allows to duplicate the stream to two internal streams.
 * @author Florent Benoit
 */
public class CloneOutputStream extends OutputStream {

    private final OutputStream first;
    private final OutputStream second;

    public CloneOutputStream(OutputStream first, OutputStream second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public void write(int b) throws IOException {
        first.write(b);
        second.write(b);
    }

    @Override
    public void write(byte b[]) throws IOException {
        first.write(b);
        second.write(b);
    }

    @Override
    public void write(byte b[], int off, int len) throws IOException {
        first.write(b, off, len);
        second.write(b, off, len);
    }


    @Override
    public void flush() throws IOException {
        first.flush();
        second.flush();
    }


    @Override
    public void close() throws IOException {
        first.close();
        second.close();
    }


}
