/**
 * Copyright 2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.testing.internal;

import org.apache.felix.gogo.commands.Option;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
* Created with IntelliJ IDEA.
* User: guillaume
* Date: 13/02/13
* Time: 10:49
* To change this template use File | Settings | File Templates.
*/
public class MetaOption extends Injection {

    private final Option option;
    private List<String> names = new ArrayList<String>();

    public MetaOption(Option option, Field field) {
        super(field, option.required());
        this.option = option;

        names.add(option.name());
        names.addAll(Arrays.asList(option.aliases()));
    }

    public List<String> getNames() {
        return names;
    }

    public boolean isValid() {
        return option.required() ? injected : true;
    }

}
