/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.testing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.AnsiOutputStream;
import org.ow2.shelbie.testing.internal.CloneOutputStream;
import org.ow2.shelbie.testing.internal.MetaArgument;
import org.ow2.shelbie.testing.internal.MetaOption;

public class ActionContainer {
    private final Action action;
    private final List<MetaOption> options = new ArrayList<MetaOption>();
    private final List<MetaArgument> arguments = new ArrayList<MetaArgument>();
    private final ByteArrayOutputStream outputStream;
    private final ByteArrayOutputStream errorStream;
    private InputStream inputStream;
    private PrintStream userOutputStream;
    private PrintStream userErrorStream;
    private InputStream userInputStream;

    public ActionContainer(Action action) {
        this.action = action;
        this.outputStream = new ByteArrayOutputStream();
        this.errorStream = new ByteArrayOutputStream();
        this.init();
    }

    public void setSystemOutputStream(PrintStream outputStream) {
        this.userOutputStream = outputStream;
    }

    public void setSystemErrorStream(PrintStream errorStream) {
        this.userErrorStream = errorStream;
    }

    public void setSystemInputStream(InputStream inputStream) {
        this.userInputStream = inputStream;
    }

    private void init() {
        Class<?> type = this.action.getClass();
        do {
            for (Field field : type.getDeclaredFields()) {
                Argument arg;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    this.options.add(new MetaOption(option, field));
                }
                if ((arg = field.getAnnotation(Argument.class)) == null) continue;
                this.arguments.add(new MetaArgument(arg, field));
            }
        } while ((type = type.getSuperclass()) != null);
    }

    public ActionContainer option(String name, Object value) {
        for (MetaOption option : this.options) {
            if (!option.getNames().contains(name)) continue;
            option.inject(this.action, value);
        }
        return this;
    }

    public ActionContainer argument(int index, Object value) {
        for (MetaArgument argument : this.arguments) {
            if (index != argument.getIndex()) continue;
            argument.inject(this.action, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandSession session) throws Exception {
        for (MetaOption option : this.options) {
            if (option.isValid()) continue;
            throw new IllegalStateException(String.format("Option %s is required%n", option.getNames().get(0)));
        }
        for (MetaArgument argument : this.arguments) {
            if (argument.isValid()) continue;
            throw new IllegalStateException(String.format("Argument %d is required%n", argument.getIndex()));
        }
        PrintStream currentOut = System.out;
        PrintStream currentErr = System.err;
        InputStream currentIn = System.in;
        try {
            this.applyStreams();
            Object object = this.action.execute(session);
            return object;
        }
        finally {
            System.setOut(currentOut);
            System.setErr(currentErr);
            System.setIn(currentIn);
        }
    }

    protected void applyStreams() {
        PrintStream actionOutputStream = this.userOutputStream != null ? new PrintStream(new CloneOutputStream(this.outputStream, this.userOutputStream)) : new PrintStream(this.outputStream);
        PrintStream actionErrorStream = this.userErrorStream != null ? new PrintStream(new CloneOutputStream(this.errorStream, this.userErrorStream)) : new PrintStream(this.errorStream);
        InputStream actionInputStream = this.userInputStream != null ? this.userInputStream : this.inputStream;
        if (actionInputStream != null) {
            System.setIn(actionInputStream);
        }
        System.setOut(actionOutputStream);
        System.setErr(actionErrorStream);
    }

    public String getSystemOut() {
        return this.getSystemOut(true);
    }

    public String getSystemOut(boolean ansiSupport) {
        String content = null;
        try {
            content = this.outputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot find encoding", e);
        }
        if (!ansiSupport) {
            return this.removeAnsi(content);
        }
        return content;
    }

    private String removeAnsi(String content) {
        if (content == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AnsiOutputStream aos = new AnsiOutputStream((OutputStream)baos);
            aos.write(content.getBytes());
            aos.flush();
            return baos.toString();
        }
        catch (IOException e) {
            return content;
        }
    }

    public String getSystemErr() {
        return this.getSystemErr(true);
    }

    public String getSystemErr(boolean ansiSupport) {
        String content = null;
        try {
            content = this.errorStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot find encoding", e);
        }
        if (!ansiSupport) {
            return this.removeAnsi(content);
        }
        return content;
    }

    public void setSystemIn(String lines) {
        this.inputStream = new ByteArrayInputStream(lines.getBytes());
    }
}

