/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.testing.internal;

import java.lang.reflect.Field;

public class Injection {
    private final Field field;
    private final boolean required;
    protected boolean injected = false;

    public Injection(Field field, boolean required) {
        this.field = field;
        this.required = required;
    }

    public void inject(Object host, Object value) {
        block20: {
            this.field.setAccessible(true);
            Class<?> type = this.field.getType();
            try {
                if (type.isPrimitive()) {
                    if (type.equals(Integer.TYPE)) {
                        this.field.setInt(host, (Integer)value);
                    } else if (type.equals(Float.TYPE)) {
                        this.field.setFloat(host, ((Float)value).floatValue());
                    } else if (type.equals(Boolean.TYPE)) {
                        this.field.setBoolean(host, (Boolean)value);
                    } else if (type.equals(Byte.TYPE)) {
                        this.field.setByte(host, (Byte)value);
                    } else if (type.equals(Character.TYPE)) {
                        this.field.setChar(host, ((Character)value).charValue());
                    } else if (type.equals(Double.TYPE)) {
                        this.field.setDouble(host, (Double)value);
                    } else if (type.equals(Long.TYPE)) {
                        this.field.setLong(host, (Long)value);
                    } else if (type.equals(Short.TYPE)) {
                        this.field.setShort(host, (Short)value);
                    }
                    break block20;
                }
                if (type.isAssignableFrom(value.getClass())) {
                    this.field.set(host, value);
                    break block20;
                }
                throw new IllegalArgumentException(String.format("Field %s (%s) cannot be injected with '%s' of type %s%n", this.field.getName(), type, value, value.getClass().getName()));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.required) {
            this.injected = true;
        }
    }
}

