/**
 * Copyright 2013 Peergreen SAS
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.testing.internal;

import java.lang.reflect.Field;

/**
 * Created with IntelliJ IDEA.
 * User: guillaume
 * Date: 13/02/13
 * Time: 11:39
 * To change this template use File | Settings | File Templates.
 */
public class Injection {
    private final Field field;
    private final boolean required;
    protected boolean injected = false;


    public Injection(Field field, boolean required) {
        this.field = field;
        this.required = required;
    }

    public void inject(Object host, Object value) {
        field.setAccessible(true);
        Class<?> type = field.getType();

        try {
            if (type.isPrimitive()) {
                // Cannot use isAssignableFrom, it does not manage primitive type
                // Cross your finger and try set the field
                if (type.equals(Integer.TYPE)) {
                    field.setInt(host, (Integer) value);
                } else if (type.equals(Float.TYPE)) {
                    field.setFloat(host, (Float) value);
                } else if (type.equals(Boolean.TYPE)) {
                    field.setBoolean(host, (Boolean) value);
                } else if (type.equals(Byte.TYPE)) {
                    field.setByte(host, (Byte) value);
                } else if (type.equals(Character.TYPE)) {
                    field.setChar(host, (Character) value);
                } else if (type.equals(Double.TYPE)) {
                    field.setDouble(host, (Double) value);
                } else if (type.equals(Long.TYPE)) {
                    field.setLong(host, (Long) value);
                } else if (type.equals(Short.TYPE)) {
                    field.setShort(host, (Short) value);
                }
            } else {
                if (type.isAssignableFrom(value.getClass())) {
                    field.set(host, value);
                } else {
                    throw new IllegalArgumentException(String.format("Field %s (%s) cannot be injected with '%s' of type %s%n", field.getName(),type, value, value.getClass().getName()));
                }
            }
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }

        if (required) {
            injected = true;
        }
    }
}
