/**
 * Copyright 2012 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.commands.builtin.internal;

import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.service.command.CommandSession;
import org.ow2.shelbie.core.ExitSessionException;

/**
 * @author Loris Bouzonnet
 */
@Component
@Command(name = "logout",
        scope = "builtin",
        description = "Log out from the current session")
@HandlerDeclaration("<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class LogoutAction implements Action {

    public Object execute(CommandSession commandSession) throws Exception {
        throw new ExitSessionException();
    }

}
