/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.shelbie.commands.builtin.internal;

import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;

import java.util.Collection;
import java.util.Collections;

/**
 * @author Loris Bouzonnet
 */
@Component
@Command(scope = "shelbie", name = "each", description = "Execute a closure on a list of arguments.")
@HandlerDeclaration("<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class EachAction implements Action {

    @Argument(name = "values", index = 0, multiValued = false, required = true, description = "The collection of arguments to iterate on")
    Collection<Object> values;

    @Argument(name = "function", index = 1, multiValued = false, required = true, description = "The function to execute")
    Function function;

    public Object execute(CommandSession session) throws Exception {
        for (Object v : values) {
            function.execute(session, Collections.singletonList(v));
        }
        return null;
    }

}
