/**
 * Copyright 2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.commands.builtin.internal;

import jline.console.history.History;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.service.command.CommandSession;

@Component
@Command(name = "history",
        scope = "shelbie",
        description = "Manage the session's history.")
@HandlerDeclaration("<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class HistoryAction implements Action {

    @Option(name = "-c",
            aliases = "--clear",
            description = "Causes the history list to be cleared by deleting all of the entries.")
    private boolean clear = false;

    @Option(name = "-d",
            aliases = "--delete",
            description = "Deletes the history entry at the given offset.")
    private int delete = -1;

    public Object execute(CommandSession session) throws Exception {

        History history = (History) session.get(History.class.getName());
        if (history == null || history.isEmpty()) {
            // Just quit
            return null;
        }

        if (clear) {
            history.clear();
            return null;
        }

        if (delete != -1) {
            if (delete >= history.size()) {
                // Out of bounds
                System.err.printf("Deletion index: %d is out of bounds (current size:%d)%n", delete, history.size());
                return null;
            }
            System.out.printf("Deleted entry %d - %s%n", delete, history.remove(delete));
            return null;
        }

        for (History.Entry entry : history) {
            System.out.printf("%6d  %s%n", entry.index(), entry.value());
        }
        return null;
    }

}
