/**
 * Copyright 2012 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core;

import org.apache.felix.gogo.commands.converter.ReifiedType;
import org.apache.felix.service.command.Converter;

/**
 * A {@code TypeBasedConverter} is using a {@code ReifiedType}
 * instead of a {@code Class} to make conversion operations.
 * This have the main advantage of nicely handling generic
 * types (like {@code List<String>})
 * @author Loris Bouzonnet
 */
public interface TypeBasedConverter extends Converter {

    /**
     * Convert an object to the desired type.
     * <p/>
     * Return null if the conversion can not be done. Otherwise return and
     * object that extends the desired type or implements it.
     *
     * @param desiredType The type that the returned object can be assigned to
     * @param in          The object that must be converted
     * @return An object that can be assigned to the desired type or null.
     */
    Object convert(ReifiedType desiredType, Object in) throws Exception;
}
