/**
 * Copyright 2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.history;

import javax.security.auth.Subject;
import java.io.File;

/**
 * A {@literal HistoryFileProvider} hides the history File location.
 * @since 2.0
 */
public interface HistoryFileProvider {

    /**
     * Determine the session's history file location.
     * @param subject identity of the session's initiator
     * @return the File where session's history will be stored (may be {@literal null})
     */
    File getHistoryFile(Subject subject);
}
