/**
 * Copyright 2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.identity;

import javax.security.auth.Subject;

/**
 * Extract a simple identity from a {@link Subject}.
 * As a {@link Subject} may contains multiple {@link java.security.Principal},
 * it is difficult to extract a single meaningful identity from this Set.
 * @since 2.0
 */
public interface IdentityProvider {

    /**
     * Extract a single identity String from the given Subject and its Principals.
     * @param subject Subject
     * @return a non {@literal null} value
     */
    String get(Subject subject);
}
