/**
 * Copyright 2012 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.converter;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.service.command.Converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Loris Bouzonnet
 */
@Component
@Provides
public class DateConverter implements Converter {

    @ServiceProperty(name = Converter.CONVERTER_CLASSES,
            value = "java.util.Date")
    private String supportedClasses;

    @Property(value = "HH:mm:ss MM/dd/yy")
    private String format;

    public Object convert(Class<?> desiredType, Object in) throws Exception {
        if (Date.class.equals(desiredType)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            try {
                return dateFormat.parse(in.toString());
            } catch (ParseException e) {
                // Try somme current formats
                dateFormat = new SimpleDateFormat("HH:mm:ss");
                try {
                    return dateFormat.parse(in.toString());
                } catch (ParseException pe) {
                    dateFormat = new SimpleDateFormat("HH:mm");
                    return dateFormat.parse(in.toString());
                }
            }
        }
        return null;
    }

    public CharSequence format(Object target, int level, Converter escape) throws Exception {
        if (target instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            return dateFormat.format(target);
        }
        return null;
    }

}
