/**
 * Copyright 2012 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.handler;

import org.osgi.framework.ServiceReference;

import java.io.Serializable;
import java.util.Comparator;

/**
 * Created by IntelliJ IDEA.
 * User: Guillaume
 * Date: 30 janv. 2010
 * Time: 12:43:49
 * To change this template use File | Settings | File Templates.
 */
public class CompleterServiceComparator implements Comparator<ServiceReference>, Serializable {

    public static final String POSITION = "completer.position";

    public int compare(ServiceReference ref1, ServiceReference ref2) {

        String pos1 = (String) ref1.getProperty(POSITION);
        String pos2 = (String) ref2.getProperty(POSITION);

        if ((pos1 != null) && (pos2 != null)) {
            // Completers are comparable
            return pos1.compareTo(pos2);
        }
        return 0;
    }
}
