/**
 * Copyright 2012-2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.handler;

import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.ActionPreparator;
import org.apache.felix.ipojo.InstanceManager;

/**
 * A Stateful Command is a command whose Action keeps state in the instance.
 * Its a singleton.
 * That means that if the user perform multiple invocation of the same command,
 * the same instance will be used.
 */
public class StatefulGogoCommand extends GogoCommand {

	public StatefulGogoCommand(InstanceManager manager,
                               ActionPreparator preparator) {
		super(manager, preparator);
	}

    @Override
	public Action createNewAction() {
        // Return the singleton POJO instance managed by the container
        // It will be auto-deleted at the end of the component's instance lifecycle
        return (Action) manager.getPojoObject();
	}

}
