/**
 * Copyright 2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.history;

import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.osgi.framework.BundleContext;
import org.ow2.shelbie.core.history.HistoryFileProvider;
import org.ow2.shelbie.core.identity.IdentityProvider;

import javax.security.auth.Subject;
import java.io.File;

/**
 * The default provider stores per-identity history file in its Bundle's private storage area.
 */
@Component
@Provides
public class DefaultHistoryFileProvider implements HistoryFileProvider {

    // TODO, make this configurable and only use data file as fallback
    private final File storage;

    private IdentityProvider identity;

    public DefaultHistoryFileProvider(BundleContext bundleContext) {
        storage = bundleContext.getDataFile("histories");
        if (!storage.exists()) {
            storage.mkdirs();
        } else {
            if (!storage.isDirectory()) {
                throw new IllegalStateException("File " + storage + " is not a directory.");
            }
        }
    }

    public File getHistoryFile(Subject subject) {
        String filename = identity.get(subject);
        return new File(storage, filename + ".history");
    }

    @Bind
    public void bindIdentityProvider(IdentityProvider identity) {
        this.identity = identity;
    }
}
