/**
 * Copyright 2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.registry.supplier.gogo.info;

import org.ow2.shelbie.core.registry.info.ArgumentInfo;
import org.ow2.shelbie.core.registry.info.CommandInfo;
import org.ow2.shelbie.core.registry.info.OptionInfo;

import java.util.ArrayList;
import java.util.List;

/**
* User: guillaume
* Date: 15/02/13
* Time: 13:41
*/
class GogoCommandInfo implements CommandInfo {
    private final String scope;
    private final String name;
    private String description;
    private List<OptionInfo> options = new ArrayList<OptionInfo>();
    private List<ArgumentInfo> arguments = new ArrayList<ArgumentInfo>();

    public GogoCommandInfo(String scope, String name) {
        this.scope = scope;
        this.name = name;
    }

    public String getScope() {
        return scope;
    }

    public List<OptionInfo> getOptions() {
        return options;
    }

    public List<ArgumentInfo> getArguments() {
        return arguments;
    }

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
