/**
 * Copyright 2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.registry.supplier.gogo.info;

import org.ow2.shelbie.core.registry.info.CommandInfo;
import org.ow2.shelbie.core.registry.info.ScopeInfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * User: guillaume
 * Date: 14/02/13
 * Time: 16:12
 */
public class GogoScopeInfo implements ScopeInfo {

    private final String name;
    private final List<CommandInfo> infos = new ArrayList<CommandInfo>();

    public GogoScopeInfo(String name) {
        this.name = name;
    }

    public Collection<CommandInfo> getCommands() {
        return infos;
    }

    public String getName() {
        return name;
    }

}
