/**
 * Copyright 2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.security;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: guillaume
 * Date: 07/02/13
 * Time: 14:55
 * To change this template use File | Settings | File Templates.
 */
public class RolesPrincipal implements Group, Serializable {

    public static final String ROLES = "roles";
    private final List<Principal> members = new ArrayList<Principal>();

    public RolesPrincipal(String... roles) {
        for (String role : roles) {
            addMember(new RolePrincipal(role));
        }
    }

    public boolean addMember(Principal principal) {
        return members.add(principal);
    }

    public boolean removeMember(Principal principal) {
        return members.remove(principal);
    }

    public boolean isMember(Principal principal) {
        return members.contains(principal);
    }

    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(members);
    }

    public String getName() {
        return ROLES;
    }

    private static class RolePrincipal implements Principal, Serializable {
        private final String role;

        public RolePrincipal(String role) {
            this.role = role;
        }

        public String getName() {
            return role;
        }
    }
}
