/**
 * Copyright 2013 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.system;

import java.io.InputStream;
import java.io.PrintStream;

/**
 * Abstract JVM related operations.
 * @since 2.0
 */
public interface SystemService {

    /**
     * Shutdown the system now.
     */
    void shutdown();

    /**
     * @return {@literal true} if the system is shutting down now.
     */
    boolean isStopping();

    /**
     * Sets the Stream for reading.
     * @param in the given inputstream
     */
    void setIn(InputStream in);

    /**
     * @return the inputstream {@link System.in}.
     */
    InputStream getIn();

    /**
     * Sets the Stream for writing {@link System.out}.
     * @param out the given printstream
     */
    void setOut(PrintStream out);

    /**
     * @return the printstream {@link System.out}.
     */
    PrintStream getOut();

    /**
     * Sets the Stream for writing {@link System.err}.
     * @param err the given printstream
     */
    void setErr(PrintStream err);

    /**
     * @return the printstream {@link System.out}.
     */
    PrintStream getErr();

}
