/**
 * Copyright 2013 Peergreen SAS
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.handler.info;

import org.ow2.shelbie.core.registry.info.CommandInfo;
import org.ow2.shelbie.core.registry.info.ScopeInfo;

import java.util.Collection;
import java.util.Collections;

/**
 * User: guillaume
 * Date: 14/02/13
 * Time: 16:11
 */
public class DefaultScopeInfo implements ScopeInfo {
    private final String scope;
    private final CommandInfo commandInfo;

    public DefaultScopeInfo(String scope, DefaultCommandInfo dci) {
        this.scope = scope;
        this.commandInfo = dci;
    }

    public Collection<CommandInfo> getCommands() {
        return Collections.singletonList(commandInfo);
    }

    public String getName() {
        return scope;
    }
}
