/**
 * Copyright 2013 Peergreen SAS
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.handler.info;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.ow2.shelbie.core.registry.info.ArgumentInfo;
import org.ow2.shelbie.core.registry.info.OptionInfo;
import org.ow2.shelbie.core.registry.info.ScopeInfo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * User: guillaume
 * Date: 14/02/13
 * Time: 17:43
 */
public class InfoBuilder {
    public ScopeInfo buildScope(Class<?> actionClass) {
        Command cmd = actionClass.getAnnotation(Command.class);
        DefaultCommandInfo dci = new DefaultCommandInfo(cmd.scope(), cmd.name(), cmd.description());
        DefaultScopeInfo dsi = new DefaultScopeInfo(cmd.scope(), dci);

        for (Field field : actionClass.getDeclaredFields()) {

            // Handle @Option
            Option option = field.getAnnotation(Option.class);
            if (option != null) {
                dci.addOption(buildOptionInfo(option, field));
            }

            // Handle @Argument
            Argument arg = field.getAnnotation(Argument.class);
            if (arg != null) {
                dci.addArgument(buildArgumentInfo(arg, field));
            }
        }

        return dsi;
    }

    private ArgumentInfo buildArgumentInfo(Argument arg, Field field) {
        DefaultArgumentInfo info = new DefaultArgumentInfo(arg.index(), field.getType());
        info.setRequired(arg.required());
        info.setMultiValued(arg.multiValued());
        info.setDescription(arg.description());
        return info;
    }

    private OptionInfo buildOptionInfo(Option option, Field field) {
        DefaultOptionInfo info = new DefaultOptionInfo(getNames(option), field.getType());
        info.setRequired(option.required());
        info.setMultiValued(option.multiValued());
        info.setDescription(option.description());
        return info;
    }

    private List<String> getNames(Option option) {
        List<String> names = new ArrayList<String>();
        names.add(option.name());
        names.addAll(Arrays.asList(option.aliases()));
        return names;
    }
}
