/**
 * Copyright 2012-2013 Bull S.A.S.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.prompt;

import org.ow2.shelbie.core.prompt.Variables;
import org.ow2.util.substitution.IPropertyResolver;

/**
 * A {@code VariablesResolver} is resolving values from the variables
 * stored in the shell session.
 *
 * @author Guillaume Sauthier
 */
public class VariablesResolver implements IPropertyResolver {

    private Variables variables;

    public VariablesResolver(Variables variables) {
        this.variables = variables;
    }

    /**
     * @return {@literal null} if the variable is unknown in the session.
     */
    public String resolve(String name) {
        Object o = variables.get(name);
        if (o != null) {
            return o.toString();
        }
        return null;
    }
}
