/**
 * Copyright 2013 Peergreen SAS
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.registry;

import org.ow2.shelbie.core.registry.info.CommandInfo;
import org.ow2.shelbie.core.registry.info.ScopeInfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * User: guillaume
 * Date: 14/02/13
 * Time: 15:00
 */
public class AggregatedScopeInfo implements ScopeInfo {

    private final String name;
    private List<ScopeInfo> fragments = new ArrayList<ScopeInfo>();

    public AggregatedScopeInfo(String name) {
        this.name = name;
    }

    public Collection<CommandInfo> getCommands() {
        Collection<CommandInfo> commands = new ArrayList<CommandInfo>();
        for (ScopeInfo scopeInfo : fragments) {
            commands.addAll(scopeInfo.getCommands());
        }
        return commands;
    }

    public String getName() {
        return name;
    }

    public void addScopeInfo(ScopeInfo info) {
        fragments.add(info);
    }

}
