/**
 * Copyright 2013 Peergreen SAS
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.registry.supplier.gogo;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.StaticServiceProperty;
import org.apache.felix.ipojo.whiteboard.Wbp;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.shelbie.core.internal.registry.supplier.gogo.info.InfoBuilder;
import org.ow2.shelbie.core.registry.info.ScopeInfo;
import org.ow2.shelbie.core.registry.supply.InfoSupplier;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * The {@literal GogoInfoSupplier} service knows how to extract descriptive information from Gogo registered commands.
 * It only handle commands <bold>not</bold> implemented as {@link org.apache.felix.service.command.Function}.
 */
@Component
@Provides(
    properties = @StaticServiceProperty(
        name = "type",
        value = "gogo",
        type = "java.lang.String")
)
@Wbp(filter = "(&(osgi.command.scope=*)(osgi.command.function=*)(!(objectclass=org.apache.felix.service.command.Function)))",
        onArrival = "bindCommand",
        onDeparture = "unbindCommand")
public class GogoInfoSupplier implements InfoSupplier {

    private final InfoBuilder builder;

    private Map<ServiceReference, ScopeInfo> scopes = new HashMap<ServiceReference, ScopeInfo>();

    public GogoInfoSupplier(BundleContext bundleContext) {
        builder = new InfoBuilder(bundleContext);
    }

    public Collection<ScopeInfo> getScopeInfo() {
        return scopes.values();
    }

    public void bindCommand(ServiceReference reference) {
        scopes.put(reference, builder.buildScopeInfo(reference));
    }

    public void unbindCommand(ServiceReference reference) {
        scopes.remove(reference);
    }
}
