/**
 * Copyright 2013 Peergreen SAS
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.registry.supplier.gogo.info;

import org.ow2.shelbie.core.registry.info.OptionInfo;

import java.util.Arrays;
import java.util.List;

/**
 * User: guillaume
 * Date: 15/02/13
 * Time: 14:07
 */
public class GogoOptionInfo extends GogoParameterInfo implements OptionInfo {
    private final List<String> names;

    public GogoOptionInfo(String[] names, Class<?> type) {
        super(type);
        this.names = Arrays.asList(names);
    }

    public List<String> getNames() {
        return names;
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}
