/**
 * Copyright 2013 Peergreen SAS
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.registry.supplier.gogo.info;

import org.ow2.shelbie.core.registry.info.ParameterInfo;

import java.util.Collection;

/**
 * User: guillaume
 * Date: 15/02/13
 * Time: 14:17
 */
public class GogoParameterInfo implements ParameterInfo {
    protected final Class<?> type;
    private String description;
    private Object defaultValue;

    public GogoParameterInfo(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return type;
    }

    public Object getDefault() {
        return defaultValue;
    }

    public boolean isRequired() {
        return true;
    }

    public boolean isMultiValued() {
        return (type.isArray()) || Collection.class.isAssignableFrom(type);
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }
}
