/**
 * Copyright 2013 Peergreen SAS
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.core.internal.registry.util;

import org.apache.felix.service.command.CommandProcessor;
import org.osgi.framework.ServiceReference;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * User: guillaume
 * Date: 14/02/13
 * Time: 14:43
 */
public class References {

    public static String getCommandScope(ServiceReference reference) {
        Object value = reference.getProperty(CommandProcessor.COMMAND_SCOPE);
        if (value == null) {
            throw new NullPointerException("Missing '" + CommandProcessor.COMMAND_SCOPE + "' property in reference");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Property '" + value + "' is not a String");
        }
        return (String) value;
    }

    public static List<String> getCommandFunctions(ServiceReference reference) {
        Object value = reference.getProperty(CommandProcessor.COMMAND_FUNCTION);
        if (value instanceof String) {
            return Collections.singletonList((String) value);
        } else if (value.getClass().isArray()
                && String.class.equals(value.getClass().getComponentType())) {
            return Arrays.asList((String[]) value);
        }

        throw new IllegalArgumentException("Property '" + value + "' is neither a String not a String[]");
    }

}
