/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.security;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesPrincipal
implements Group,
Serializable {
    public static final String ROLES = "roles";
    private final List<Principal> members = new ArrayList<Principal>();

    public RolesPrincipal(String ... roles) {
        for (String role : roles) {
            this.addMember(new RolePrincipal(role));
        }
    }

    public boolean addMember(Principal principal) {
        return this.members.add(principal);
    }

    public boolean removeMember(Principal principal) {
        return this.members.remove(principal);
    }

    public boolean isMember(Principal principal) {
        return this.members.contains(principal);
    }

    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(this.members);
    }

    public String getName() {
        return ROLES;
    }

    private static class RolePrincipal
    implements Principal,
    Serializable {
        private final String role;

        public RolePrincipal(String role) {
            this.role = role;
        }

        public String getName() {
            return this.role;
        }
    }
}

