/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.scheduler.internal.command;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.ow2.shelbie.commands.scheduler.service.ISchedulerService;

@Command(name="at", scope="scheduler", description="Schedule execution of function")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class SchedulerCommand
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __FschedulerService;
    @Requires
    private ISchedulerService schedulerService;
    private boolean __Ffunction;
    @Argument(name="function", index=0, multiValued=false, required=true, description="The function to execute")
    private Function function;
    private boolean __Fdate;
    @Option(name="-w", aliases={"--when"}, multiValued=false, required=false, description="The date to schedule the function execution")
    private Date date;
    private boolean __Fdelay;
    @Option(name="-d", aliases={"--delay"}, multiValued=false, required=false, description="The delay to schedule the function execution")
    private Long delay;
    private boolean __FexecutorService;
    private ExecutorService executorService;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    ISchedulerService __getschedulerService() {
        if (!this.__FschedulerService) {
            return this.schedulerService;
        }
        return (ISchedulerService)this.__IM.onGet((Object)this, "schedulerService");
    }

    void __setschedulerService(ISchedulerService iSchedulerService) {
        if (!this.__FschedulerService) {
            this.schedulerService = iSchedulerService;
            return;
        }
        this.__IM.onSet((Object)this, "schedulerService", (Object)iSchedulerService);
    }

    Function __getfunction() {
        if (!this.__Ffunction) {
            return this.function;
        }
        return (Function)this.__IM.onGet((Object)this, "function");
    }

    void __setfunction(Function function) {
        if (!this.__Ffunction) {
            this.function = function;
            return;
        }
        this.__IM.onSet((Object)this, "function", (Object)function);
    }

    Date __getdate() {
        if (!this.__Fdate) {
            return this.date;
        }
        return (Date)this.__IM.onGet((Object)this, "date");
    }

    void __setdate(Date date) {
        if (!this.__Fdate) {
            this.date = date;
            return;
        }
        this.__IM.onSet((Object)this, "date", (Object)date);
    }

    Long __getdelay() {
        if (!this.__Fdelay) {
            return this.delay;
        }
        return (Long)this.__IM.onGet((Object)this, "delay");
    }

    void __setdelay(Long l) {
        if (!this.__Fdelay) {
            this.delay = l;
            return;
        }
        this.__IM.onSet((Object)this, "delay", (Object)l);
    }

    ExecutorService __getexecutorService() {
        if (!this.__FexecutorService) {
            return this.executorService;
        }
        return (ExecutorService)this.__IM.onGet((Object)this, "executorService");
    }

    void __setexecutorService(ExecutorService executorService) {
        if (!this.__FexecutorService) {
            this.executorService = executorService;
            return;
        }
        this.__IM.onSet((Object)this, "executorService", (Object)executorService);
    }

    public SchedulerCommand() {
        this(null);
    }

    private SchedulerCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setexecutorService(Executors.newSingleThreadExecutor());
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(final CommandSession commandSession) throws Exception {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                new Thread(new ExecuteFunctionRunnable(commandSession)).start();
            }
        };
        if (this.__getdate() != null) {
            this.__getschedulerService().scheduleJob(timerTask, this.__getdate());
        } else if (this.__getdelay() != null) {
            this.__getschedulerService().scheduleJob(timerTask, this.__getdelay().longValue());
        } else {
            this.__getexecutorService().execute(new ExecuteFunctionRunnable(commandSession));
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("date")) {
                this.__Fdate = true;
            }
            if (set.contains("delay")) {
                this.__Fdelay = true;
            }
            if (set.contains("executorService")) {
                this.__FexecutorService = true;
            }
            if (set.contains("function")) {
                this.__Ffunction = true;
            }
            if (set.contains("schedulerService")) {
                this.__FschedulerService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class ExecuteFunctionRunnable
    implements Runnable {
        private final CommandSession commandSession;

        public ExecuteFunctionRunnable(CommandSession commandSession) {
            this.commandSession = commandSession;
        }

        public void run() {
            try {
                SchedulerCommand.this.__getfunction().execute(this.commandSession, Collections.emptyList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

