/**
 * Copyright 2010 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.shelbie.commands.ssh.internal.command;

import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.shelbie.commands.ssh.server.Constants;

@Component
@Command(name="list-daemons", scope="ssh", description="List started SSH daemons")
@HandlerDeclaration("<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class ListSshdCommand implements Action {

    private static final String FILTER = "(" + ConfigurationAdmin.SERVICE_FACTORYPID
            + "=" + Constants.SSHD_COMPONENT_NAME + ")";

	@Requires
	private ConfigurationAdmin configurationAdmin;

	public Object execute(CommandSession session) throws Exception {

        // Look the SSHDaemonComponent instances
        Configuration[] configurations = configurationAdmin.listConfigurations(FILTER);
		return configurations;
	}
}
