/**
 * Copyright 2012 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.shelbie.commands.ssh.server.internal;

import java.io.File;

/**
 * @author Loris Bouzonnet
 */
public class HostKey {

    private final String user;
    private final File objKey;
    private final File rsaKey;
    private final File dsaKey;
    private final File peerKeys;


    public HostKey(final String user, File objKey, File rsaKey, File dsaKey, final File peerKeys) {
        this.user = user;
        this.objKey = objKey;
        this.rsaKey = rsaKey;
        this.dsaKey = dsaKey;
        this.peerKeys = peerKeys;
    }

    public String getUser() {
        return user;
    }

    public File getObjKey() {
        return objKey;
    }

    public File getRsaKey() {
        return rsaKey;
    }

    public File getDsaKey() {
        return dsaKey;
    }

    public File getPeerKeys() {
        return peerKeys;
    }

    public static HostKey findHostKey() {

        File rsaKey = null;
        File dsaKey = null;
        File peerKeys = null;

        String user = System.getProperty("user.name");
        String userHome = System.getProperty("user.home");
        File fUserHome = new File(userHome);
        File sshHome = new File(fUserHome, ".ssh");
        if (sshHome.exists()) {
            rsaKey = new File(sshHome, "id_rsa");
            dsaKey = new File(sshHome, "id_dsa");
            peerKeys = new File(sshHome, "authorized_keys");
        }
        
        return new HostKey(user, null, rsaKey, dsaKey, peerKeys);
    }

}
