/**
 * Copyright 2012 OW2 Shelbie
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.shelbie.commands.ssh.server.internal;

import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.bouncycastle.openssl.PasswordFinder;

/**
 * @author Loris Bouzonnet
 */
public class SimplePasswordFinder implements PasswordFinder, PasswordFinderSetter {
    
    private final String password;

    public SimplePasswordFinder(String password) {
        this.password = password;
    }

    public char[] getPassword() {
        return password.toCharArray();
    }

    public void setPasswordFinder(KeyPairProvider provider) {
        if (provider instanceof FileKeyPairProvider) {
            ((FileKeyPairProvider) provider).setPasswordFinder(this);
        }
    }
}
