/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.EnumSet;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.ForwardingFilter;
import org.apache.sshd.server.session.ServerSession;

public class TcpipForwardSupport
extends IoHandlerAdapter {
    private final ServerSession session;
    private IoAcceptor acceptor;

    public TcpipForwardSupport(ServerSession session) {
        this.session = session;
    }

    public synchronized void initialize() {
        if (this.acceptor == null) {
            NioSocketAcceptor acceptor = this.session.getServerFactoryManager().getTcpipForwardingAcceptorFactory().createNioSocketAcceptor(this.session);
            acceptor.setHandler(this);
            acceptor.setReuseAddress(true);
            acceptor.getFilterChain().addLast("executor", new ExecutorFilter(EnumSet.complementOf(EnumSet.of(IoEventType.SESSION_CREATED)).toArray(new IoEventType[0])));
            this.acceptor = acceptor;
        }
    }

    public synchronized void close() {
        if (this.acceptor != null) {
            this.acceptor.dispose();
            this.acceptor = null;
        }
    }

    synchronized void request(Buffer buffer, boolean wantReply) throws IOException {
        SocketAddress a;
        InetSocketAddress addr;
        String address = buffer.getString();
        int port = buffer.getInt();
        try {
            addr = new InetSocketAddress(address, port);
        }
        catch (RuntimeException e) {
            addr = null;
        }
        ForwardingFilter filter = this.session.getServerFactoryManager().getForwardingFilter();
        if (addr == null || filter == null || !filter.canListen(addr, this.session)) {
            if (wantReply) {
                buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_REQUEST_FAILURE, 0);
                this.session.writePacket(buffer);
            }
            return;
        }
        this.initialize();
        Set<SocketAddress> a1 = this.acceptor.getLocalAddresses();
        try {
            this.acceptor.bind(addr);
        }
        catch (IOException bindErr) {
            if (this.acceptor.getLocalAddresses().isEmpty()) {
                this.close();
            }
            if (wantReply) {
                buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_REQUEST_FAILURE, 0);
                this.session.writePacket(buffer);
            }
            return;
        }
        Set<SocketAddress> a2 = this.acceptor.getLocalAddresses();
        a2.removeAll(a1);
        if (a2.size() == 1 && (a = a2.iterator().next()) instanceof InetSocketAddress) {
            port = ((InetSocketAddress)a).getPort();
        }
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_REQUEST_SUCCESS, 0);
            buffer.putInt(port);
            this.session.writePacket(buffer);
        }
    }

    synchronized void cancel(Buffer buffer, boolean wantReply) throws IOException {
        String address = buffer.getString();
        int port = buffer.getInt();
        if (this.acceptor != null) {
            this.acceptor.unbind(new InetSocketAddress(address, port));
        }
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_REQUEST_SUCCESS, 0);
            this.session.writePacket(buffer);
        }
    }

    public void sessionCreated(IoSession session) throws Exception {
        final ChannelForwardedTcpip channel = new ChannelForwardedTcpip(session);
        session.setAttribute(ChannelForwardedTcpip.class, channel);
        this.session.registerChannel(channel);
        channel.open().addListener(new SshFutureListener<OpenFuture>(){

            @Override
            public void operationComplete(OpenFuture future) {
                Throwable t = future.getException();
                if (t != null) {
                    TcpipForwardSupport.this.session.unregisterChannel(channel);
                    channel.close(false);
                }
            }
        });
    }

    public void sessionClosed(IoSession session) throws Exception {
        ChannelForwardedTcpip channel = (ChannelForwardedTcpip)session.getAttribute(ChannelForwardedTcpip.class);
        if (channel != null) {
            channel.close(false);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        ChannelForwardedTcpip channel = (ChannelForwardedTcpip)session.getAttribute(ChannelForwardedTcpip.class);
        IoBuffer ioBuffer = (IoBuffer)message;
        int r = ioBuffer.remaining();
        byte[] b = new byte[r];
        ioBuffer.get(b, 0, r);
        channel.waitFor(130, Long.MAX_VALUE);
        channel.getOut().write(b, 0, r);
        channel.getOut().flush();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
        session.close(false);
    }

    public static class ChannelForwardedTcpip
    extends AbstractClientChannel {
        private final IoSession serverSession;

        public ChannelForwardedTcpip(IoSession serverSession) {
            super("forwarded-tcpip");
            this.serverSession = serverSession;
        }

        public OpenFuture getOpenFuture() {
            return this.openFuture;
        }

        public synchronized OpenFuture open() throws Exception {
            InetSocketAddress remote = (InetSocketAddress)this.serverSession.getRemoteAddress();
            InetSocketAddress local = (InetSocketAddress)this.serverSession.getLocalAddress();
            if (this.closeFuture.isClosed()) {
                throw new SshException("Session has been closed");
            }
            this.openFuture = new DefaultOpenFuture(this.lock);
            this.log.info("Send SSH_MSG_CHANNEL_OPEN on channel {}", (Object)this.id);
            Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN, 0);
            buffer.putString(this.type);
            buffer.putInt(this.id);
            buffer.putInt(this.localWindow.getSize());
            buffer.putInt(this.localWindow.getPacketSize());
            buffer.putString(local.getAddress().getHostAddress());
            buffer.putInt(local.getPort());
            buffer.putString(remote.getAddress().getHostAddress());
            buffer.putInt(remote.getPort());
            this.session.writePacket(buffer);
            return this.openFuture;
        }

        protected synchronized void doOpen() throws Exception {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        }

        protected synchronized void doClose() {
            this.serverSession.close(false);
            super.doClose();
        }

        protected synchronized void doWriteData(byte[] data, int off, int len) throws IOException {
            IoBuffer buf = IoBuffer.allocate(len);
            buf.put(data, off, len);
            buf.flip();
            this.localWindow.consumeAndCheck(len);
            this.serverSession.write(buf);
        }

        public void handleEof() throws IOException {
            super.handleEof();
            this.serverSession.close(false);
        }
    }
}

