/*
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.spec.testengine.metadata;

import org.ow2.spec.testengine.SignatureResultSet;


public class EnumAnnotationMetadata  extends AbsMetadata {

    private String name = null;

    private String desc = null;

    private String value = null;



    public EnumAnnotationMetadata(String name, String desc, String value) {
        this.name = name;
        this.desc = desc;
        this.value = value;
    }


    public String getName() {
        return name;
    }

    public void compare(EnumAnnotationMetadata other, SignatureResultSet rs) {
        // compare name
        compare(getName() + " name", name, other.name, rs);

        // compare desc
        compare(getName() + " desc", desc, other.desc, rs);

        // compare value
        compare(getName() + " value", value, other.value, rs );



    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EnumAnnotationMetadata)) {
            return false;
        }

        SignatureResultSet rs = new SignatureResultSet();
        try {
            compare((EnumAnnotationMetadata) o, rs);
        } catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }
    @Override
    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();

        sb.append("\n");
        sb.append(indent);
        sb.append("<enum-annotation");

        // attributes

        // name Attribute
        addObjectToSB("name", name, sb);

        // desc Attribute
        addObjectToSB("desc", desc, sb);

        // value Attribute
        addObjectToSB("value", value, sb);

        // close element
        sb.append(" />");

        return sb.toString();
    }

}
